#!/usr/bin/python3

# system-config-language.py - The startup script for system-config-language
# Copyright (C) 2002-2015 Red Hat, Inc.
# Copyright (C) 2002, 2003 Brent Fox <bfox@redhat.com>
# Copyright (C) 2013-2015 Parag Nemade <pnemade@redhat.com>
##
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
##
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
##
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

from __future__ import print_function

import sys
import getopt
import os

import gettext
_ = lambda x: gettext.translation(
    "system-config-language", fallback=True).gettext(x) if x != "" else ""
N_ = lambda x: x


class SystemConfigLanguage(object):

    @classmethod
    def use_text_mode(cls):
        import language_tui
        language_tui.TUIWindow()

    @classmethod
    def use_gui_mode(cls):
        import language_gui
        app = language_gui.GUIWindow()
        app.run(sys.argv)

    @classmethod
    def use_cli_mode(cls):
        sys.stderr.write(_("Usage: system-config-language [--text]\n"))
        sys.exit(0)

    def run(self):
        try:
            getopt.getopt(sys.argv[1:], "ht", ["help", "text"])
        except getopt.GetoptError as err:
            print(err)
            self.use_cli_mode()
            sys.exit(2)

        if "--text" in sys.argv or "-t" in sys.argv:
            self.use_text_mode()
        elif "--help" in sys.argv or "-h" in sys.argv:
            self.use_cli_mode()
        else:
            try:
                if os.environ['DISPLAY'] != None:
                    self.use_gui_mode()
            except KeyError:
                print(_("Starting graphical mode failed.  Starting \
                                           text mode instead."))
                self.use_text_mode()

if __name__ == "__main__":
    scl = SystemConfigLanguage()
    scl.run()
