/*
  Copyright (C) 2017 SUSE LLC

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) version 3.0 of the License. This library
  is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
  License for more details. You should have received a copy of the GNU
  Lesser General Public License along with this library; if not, write
  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
  Floor, Boston, MA 02110-1301 USA
*/

#include <microhttpd.h>
#include <json/json.h>

#define YUILogComponent "http-ui"
#include <yui/YUILog.h>
#include <yui/YApplication.h>

#include "YJsonSerializer.h"
#include "YHttpAppHandler.h"


void YHttpAppHandler::process_request(struct MHD_Connection* connection,
    const char* url, const char* method, const char* upload_data,
    size_t* upload_data_size, std::ostream& body, int& error_code,
    std::string& content_type, bool *redraw)
{
    Json::Value info;
    YApplication *app = YUI::app();

    info["animation_support"] = app->hasAnimationSupport();
    info["application_icon"] = app->applicationIcon();
    info["application_title"] = app->applicationTitle();
    info["debug_log"] = YUILog::debugLoggingEnabled();
    info["default_height"] = app->defaultHeight();
    info["default_width"] = app->defaultWidth();
    info["display_colors"] = Json::Value::Int64(app->displayColors());
    info["display_depth"] = app->displayDepth();
    info["display_height"] = app->displayHeight();
    info["display_width"] = app->displayWidth();
    info["icon_path"] = app->iconBasePath();
    info["icon_support"] = app->hasIconSupport();
    info["image_support"] = app->hasImageSupport();
    info["language"] = app->language();
    info["left_handed_mouse"] = app->leftHandedMouse();
    info["product_name"] = app->productName();
    info["rich_text_table_support"] = app->richTextSupportsTable();
    info["text_mode"] = app->isTextMode();
    info["utf8_support"] = app->hasFullUtf8Support();
    info["wizard_support"] = app->hasWizardDialogSupport();

    std::map<std::string,std::string> relnotes = app->releaseNotes();
    if (!relnotes.empty()) {
        Json::Value relnotes_json;

        for(const auto &pair: relnotes) {
            relnotes_json[pair.first] = pair.second;
        }

        info["release_notes"] = relnotes_json;
    }

    YJsonSerializer::save(info, body);
    error_code = MHD_HTTP_OK;
    content_type = "application/json";
}
