/*
  Copyright (C) 2000-2012 Novell, Inc
  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) version 3.0 of the License. This library
  is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
  License for more details. You should have received a copy of the GNU
  Lesser General Public License along with this library; if not, write
  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
  Floor, Boston, MA 02110-1301 USA
*/


/*-/

   File:       position.cc

   Author:     Michael Andres <ma@suse.de>

/-*/

#include <iostream>
#include "position.h"


std::ostream & operator<<( std::ostream & str, const wpos & obj )
{
    return str << '(' << obj.L << ',' << obj.C << ')';
}


std::ostream & operator<<( std::ostream & str, const wpair & obj )
{
    return str << '(' << obj.A << ',' << obj.B << ')';
}


std::ostream & operator<<( std::ostream & str, const wsze & obj )
{
    return str << '[' << obj.H << 'x' << obj.W << ']';
}

std::ostream & operator<<( std::ostream & str, const wrect & obj )
{
    return str << '{' << obj.Pos << obj.Sze << '}';
}
